library(MASS)
library(lattice)

### linear mixed models


petrol<-read.csv("../CSV/petrol.csv")
xyplot(Y ~ EP | No, petrol,
	panel = function(x, y, ...) {
		panel.xyplot(x, y, ...)
		panel.lmline(x, y, col = 3, lty = 4)
	},
	as.table = T,
	aspect = "xy",
	xlab = "End point",
	ylab = "Yield (%)")

###
petrol.lm1 <- aov(Y ~ No/EP, petrol)
petrol.lm2 <- aov(Y ~ No + EP, petrol)
anova(petrol.lm2, petrol.lm1)
petrol.lm3 <- aov(Y ~ . - No, petrol)
anova(petrol.lm3, petrol.lm2)


###
tmp <- update(petrol.lm2, .~.-1)
tmp
a0 <- predict(tmp, type="terms")[, "No"]
b0 <- coef(tmp)["EP"]

a <- with(petrol, cbind(1, SG, VP, V10)) %*%
        coef(petrol.lm3)[1:4]
b <- coef(petrol.lm3)["EP"]

palette(c("red", "blue", "orange"))

#parallel regressions do not explain the change in the intercepts
xyplot(Y ~ EP | No, petrol, subscripts = T,
	panel = function(x, y, subscripts, ...) {
		panel.xyplot(x, y, ...)
		panel.lmline(x, y, col = 3, lty = 3,lwd=2)
		panel.abline(a0[subscripts][1], b0, col = 4, lty = 4)
		panel.abline(a[subscripts][1], b, col = 5, lty = 5)
	}, as.table = T, aspect = "xy", xlab = "End point",
	ylab = "Yield (%)")

####
require(nlme)
petrol.lme <- lme(Y ~ SG + VP + V10 + EP,
  data = petrol, random = ~1 | No)

summary(petrol.lme)$coef

###
round(summary.lm(petrol.lm3)$coef, 5)

#### hints of shrinkage

dat <- with(petrol,
  expand.grid(No = levels(No), SG = mean(SG),
      VP = mean(VP), V10=mean(V10), EP = mean(EP)))

fixM <- predict(petrol.lm2, dat)
ranM <- predict(petrol.lme, dat)
conM <- predict(petrol.lm3, dat)

X <- rbind(cbind(1,fixM), cbind(2,ranM), cbind(3,conM))
plot(X, axes = F, ann = F)

segments(1,fixM, 2,ranM)
segments(2,ranM, 3,conM)

### adding a random slope term

petrol.lme2 <- lme(Y ~ SG + VP + V10 + EP, data = petrol,random = ~ 1 + EP | No)

summary(petrol.lme2)
anova(petrol.lme,petrol.lme2)

#The test is valid under ML estimation (??) just have to check
pet.lm1<-update(petrol.lme,method="ML")
pet.lm2<-update(petrol.lme2,method="ML")
anova(pet.lm1,pet.lm2)
